/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_11659;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_827;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Quaternionfc;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibClientServices;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;

public class GeoBlockRenderer<T extends class_2586, R extends class_11954>
implements GeoRenderer<T, Void, R>,
class_827<T, R> {
    protected final GeoRenderLayersContainer<T, Void, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;

    public GeoBlockRenderer(class_2591<? extends T> blockEntityType) {
        this(new DefaultedBlockGeoModel(Objects.requireNonNull(class_7923.field_41181.method_10221(blockEntityType))));
    }

    public GeoBlockRenderer(GeoModel<T> model) {
        this.model = model;
    }

    protected class_2350 getBlockStateDirection(T blockEntity) {
        class_2680 blockState = blockEntity.method_11010();
        for (class_2754 property : new class_2754[]{class_2741.field_12525, class_2741.field_12481, class_2741.field_28062, class_2741.field_12545}) {
            if (!blockState.method_28498((class_2769)property)) continue;
            return (class_2350)blockState.method_11654((class_2769)property);
        }
        return class_2350.field_11043;
    }

    protected void tryRotateByBlockstate(RenderPassInfo<R> renderPassInfo, class_4587 poseStack) {
        class_2350 facing = renderPassInfo.getOrDefaultGeckolibData(DataTickets.BLOCK_FACING, class_2350.field_11043);
        switch (facing) {
            case field_11035: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11034: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40715.rotationDegrees(90.0f));
                break;
            }
            case field_11036: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case field_11033: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(90.0f));
                break;
            }
        }
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, Void, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoBlockRenderer<T, R> withRenderLayer(Function<? super GeoBlockRenderer<T, R>, GeoRenderLayer<T, Void, R>> renderLayer) {
        return this.withRenderLayer(renderLayer.apply(this));
    }

    public GeoBlockRenderer<T, R> withRenderLayer(GeoRenderLayer<T, Void, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoBlockRenderer<T, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoBlockRenderer<T, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.OverrideOnly
    public long getInstanceId(T animatable, @Nullable Void ignored) {
        return animatable.method_11016().hashCode();
    }

    @Override
    @ApiStatus.Internal
    public void captureDefaultRenderState(T animatable, @Nullable Void relatedObject, R renderState, float partialTick) {
        GeoRenderer.super.captureDefaultRenderState(animatable, relatedObject, renderState, partialTick);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.BLOCKSTATE, animatable.method_11010());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.POSITION, class_243.method_24953((class_2382)animatable.method_11016()));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.BLOCK_FACING, this.getBlockStateDirection(animatable));
    }

    @Override
    public void preRenderPass(RenderPassInfo<R> renderPassInfo, class_11659 renderTasks) {
        renderPassInfo.poseStack().method_22904(0.5, 0.0, 0.5);
    }

    @Override
    public void scaleModelForRender(RenderPassInfo<R> renderPassInfo, float widthScale, float heightScale) {
        GeoRenderer.super.scaleModelForRender(renderPassInfo, this.scaleWidth * widthScale, this.scaleHeight * heightScale);
    }

    @Override
    public void adjustRenderPose(RenderPassInfo<R> renderPassInfo) {
        this.tryRotateByBlockstate(renderPassInfo, renderPassInfo.poseStack());
    }

    @ApiStatus.Internal
    public void method_3569(R renderState, class_4587 poseStack, class_11659 renderTasks, class_12075 cameraRenderState) {
        GeoRenderer.super.performRenderPass(renderState, poseStack, renderTasks, cameraRenderState);
    }

    @ApiStatus.Internal
    public R method_74335() {
        return (R)new class_11954();
    }

    public void method_74331(T blockEntity, R renderState, float partialTick, class_243 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_11683.class_11792 damageOverlayState) {
        super.method_74331(blockEntity, renderState, partialTick, cameraPos, damageOverlayState);
        this.fillRenderState(blockEntity, null, renderState, partialTick);
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibClientServices.EVENTS.fireCompileBlockRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, @Nullable Void relatedObject, R renderState, float partialTick) {
        GeckoLibClientServices.EVENTS.fireCompileBlockRenderState(this, renderState, animatable);
    }

    @Override
    public boolean firePreRenderEvent(RenderPassInfo<R> renderPassInfo, class_11659 renderTasks) {
        return GeckoLibClientServices.EVENTS.fireBlockPreRender(renderPassInfo, renderTasks);
    }

    @Override
    @Deprecated
    @ApiStatus.Internal
    public final R createRenderState(T animatable, @Nullable Void relatedObject) {
        return (R)new class_11954();
    }
}

